/* SAMHAIN file system integrity testing                                   */
/* Copyright (C) 1999, 2000 Rainer Wichmann                                */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */

#ifndef SH_FILES_H
#define SH_FILES_H

/* check the setup
 */
int sh_files_test_setup (void);

/* check if allignore
 */
int sh_files_is_allignore (char * str);

/* set recursion depth
 */
int sh_files_setrec (void);

/* report only once
 */
int sh_files_reportonce(char * c);

/* report full details
 */
int sh_files_fulldetail(char * c);

/* reset the 'checked' flag
 */
void sh_dirs_reset(void);

/* reset the 'checked' flag
 */
void sh_files_reset(void);

/* set maximum recursion level
 */
int sh_files_setrecursion (char * flag_s);

/* push a directory on the stack USER0
 */
int  sh_files_pushdir_user0 (char * dirName);

/* push a directory on the stack USER1
 */
int  sh_files_pushdir_user1 (char * dirName);

/* push a directory on the stack ATTR
 */
int  sh_files_pushdir_attr (char * dirName);

/* push a directory on the stack READONLY
 */
int  sh_files_pushdir_ro (char * dirName);

/* push a directory on the stack LOGFILE
 */
int  sh_files_pushdir_log (char * dirName);

/* push a directory on the stack GROWING LOGFILE
 */
int  sh_files_pushdir_glog (char * dirName);

/* push a directory on the stack IGNORE NONE
 */
int  sh_files_pushdir_noig (char * dirName);

/* push a directory on the stack IGNORE ALL 
 */
int  sh_files_pushdir_allig (char * dirName);


/* push a file on the stack USER0
 */
int  sh_files_pushfile_user0 (char * dirName);

/* push a file on the stack USER1
 */
int  sh_files_pushfile_user1 (char * dirName);

/* push a file on the stack ATTR
 */
int  sh_files_pushfile_attr (char * dirName);

/* push a file on the stack READONLY
 */
int  sh_files_pushfile_ro (char * dirName);

/* push a file on the stack LOGFILE
 */
int  sh_files_pushfile_log (char * dirName);

/* push a file on the stack GROWING LOGFILE
 */
int  sh_files_pushfile_glog (char * dirName);

/* push a file on the stack IGNORE NONE
 */
int  sh_files_pushfile_noig (char * dirName);

/* push a file on the stack IGNORE ALL
 */
int  sh_files_pushfile_allig (char * dirName);


/* check directories on the stack
 */
unsigned long sh_dirs_chk       (void);

/* check files on the stack
 */
unsigned long sh_files_chk       (void);

int sh_files_deldirstack (void);

int sh_files_delfilestack (void);


int sh_files_redef_user0(char * str);
int sh_files_redef_user1(char * str);
int sh_files_redef_readonly(char * str);
int sh_files_redef_loggrow(char * str);
int sh_files_redef_logfiles(char * str);
int sh_files_redef_attributes(char * str);
int sh_files_redef_noignore(char * str);
int sh_files_redef_allignore(char * str);


#endif




