#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

echo; echo "${S}__ STARTING TEST RUN CLIENT/SERVER W/MYSQL __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi

echo MAKE is $MAKE
echo


testrun2c ()
{
	#
	# test standalone compilation
	#
	echo "${S}Building client and server${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
        #
        #
	./configure --quiet  $TRUST --enable-login-watch --enable-xml-log --enable-debug --enable-network=client --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2 --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-logserver=${SH_LOCALHOST}  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	# save binary and build server
	#
	cp samhain samhain.build
	make clean

        #
	./configure --quiet  $TRUST --enable-xml-log --with-database=mysql --with-libs=-L/usr/local/mysql/lib --with-cflags=-I/usr/local/mysql/include --enable-static --enable-debug --enable-network=server --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2 --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-logserver=${SH_LOCALHOST}  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi
	echo "${S}Initialize database${E}"; echo;

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock
	rm -f ./rc.${SH_LOCALHOST}
	rm -f ./file.${SH_LOCALHOST}

	cp testrc_2.in testrc_2

	# Create a password
	SHPW=`./yule -G`
	if test x"$SHPW" = x; then
	    echo "password not generated -- aborting"
	    exit 1
	fi

	# Set in client
	echo "./samhain_setpwd samhain.build new $SHPW"
	./samhain_setpwd samhain.build new $SHPW
	mv samhain.build.new samhain.new
	SHCLT=`./yule -P $SHPW | sed s%HOSTNAME%${SH_LOCALHOST}%`
 	echo $SHCLT >> testrc_2

	echo "./samhain.new -t init"
	./samhain.new -t init

	SHINI=$?

	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	cp    ./testrc_2              ./rc.${SH_LOCALHOST}
	mv    ./.samhain_file         ./file.${SH_LOCALHOST}

	if test x$SHINI = x0; then

		echo; echo "${S}Start Server${E}: ./yule  &"; echo;
		./yule &
		PROC_Y=$!
		sleep 5

		echo; echo "${S}Start Client${E}: ./samhain.new -l none -p none -e info -t check";

		./samhain.new -t check -p none -l none -e info 
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    kill $PROC_Y
		    exit
		fi

		kill $PROC_Y
		sleep 5
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $SHINI"; 
		echo;
		exit
	fi
	    
}

    if test x$1 = x; then
	echo
	echo "Please provide the local hostname as argument."
	echo
	exit 8
    fi

    export SH_LOCALHOST=$1

    testrun2c


echo; echo "${S}__ END TEST RUN CLIENT/SERVER W/MYSQL __${E}"; echo;

exit

