#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

#echo; echo "${S}__ STARTING TEST HASH FUNCTION __${E}"; echo;
#echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi



testhash ()
{
	#
	# test standalone compilation
	#
	TEST="${S}standalone agent${E}"
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
	#
	./configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	if test x$? = x0; then
		echo "PASS: configure ${TEST}"; 
		$MAKE  > /dev/null 2>> test_log
		if test x$? = x0; then
		    echo "PASS: $MAKE  ${TEST}";
 		else
		    echo "FAIL: $MAKE  ${TEST} (see ./test_log)";
		fi
	else
		echo "FAIL: configure  ${TEST} (see ./test_log)"; 
	fi

	echo "Test results of the TIGER hash algorithm" > testhash.tmp
	echo >> testhash.tmp
	echo "(use samhain -H string to test)" >> testhash.tmp
	echo >> testhash.tmp
	./samhain -H "" >> testhash.tmp
	./samhain -H "abc" >> testhash.tmp
	./samhain -H "Tiger" >> testhash.tmp
	./samhain -H "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-" >> testhash.tmp
	./samhain -H "ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789" >> testhash.tmp
	./samhain -H "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham" >> testhash.tmp
	./samhain -H "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge." >> testhash.tmp
	./samhain -H "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge, 1996." >> testhash.tmp
	./samhain -H "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-" >> testhash.tmp

	# echo
	# echo "${S}diff testhash.tmp testtiger.txt (empty == success):${E}" 
	# echo
	RESU=`diff testhash.tmp testtiger.txt`
	if test "x${RESU}" = "x"; then
	    echo "PASS: test_hash"
	else
	    echo "FAIL: test_hash"
	fi

}



	testhash


#echo; echo "${S}__ END TEST HASH FUNCTION __${E}"; echo;

exit

