#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

echo; echo "${S}__ STARTING TEST RUN CLIENT/SERVER __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi

echo MAKE is $MAKE
echo

# --with-database=postgresql
# export MYLIB=-L/usr/local/pgsql/lib
# export MYINC=-I/usr/local/pgsql/include
# export LD_LIBRARY_PATH=/usr/local/pgsql/lib

# --with-database=mysql
# export MYLIB=-L/usr/local/mysql/lib
# export MYINC=-I/usr/local/mysql/include
# export LD_LIBRARY_PATH=/usr/local/mysql/lib

testrun2d ()
{
	#
	# test standalone compilation
	#
	echo "${S}Building client and server${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
	#
	./configure --quiet  $TRUST --enable-network=client  --enable-xml-log --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/testrc_2  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	# save binary and build server
	#
	cp samhain samhain.build
	make clean

	./configure --quiet  $TRUST --enable-network=server  --enable-xml-log --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/testrc_2  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file --enable-udp --enable-identity=rainer
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	#################################################################
	#
	#
	echo "${S}Initialize database${E}"; echo;

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	cp testrc_2.in testrc_2

	echo "./samhain.build -t init"
	./samhain.build -t init

	SHINI=$?

	# Create a password

	SHPW=`./yule -G 2>&1 | grep -v 'ERRO'`
	if test x"$SHPW" = x; then
	    echo "password not generated -- aborting"
	    exit 1
	fi

	# Set in client

	echo "./samhain_setpwd samhain.build new $SHPW"
	./samhain_setpwd samhain.build new $SHPW

	mv samhain.build.new  samhain.new

	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	SHCLT=`./yule -P $SHPW  2>&1 | grep -v 'ERRO' | sed s%HOSTNAME%${SH_LOCALHOST}%`

 	echo $SHCLT >> testrc_2

	if test x$SHINI = x0; then
		echo; echo "${S}Start Server${E}: ./yule  &"; echo;
		su -c "./yule &"
		PROC_Y=$!
		sleep 5

		echo; echo "${S}Start Client${E}: ./samhain.new -l none -p none -e info -t check";

		./samhain.new -t check -p none -l none -e info
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    kill $PROC_Y
		    exit
		fi

		kill $PROC_Y
		sleep 5
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $SHINI"; 
		echo;
		exit
	fi
	    
}

    if test x$1 = x; then
	echo
	echo "Please provide the local hostname as argument."
	echo
	exit 8
    fi

    export SH_LOCALHOST=$1

    testrun2d


echo; echo "${S}__ END TEST RUN CLIENT/SERVER __${E}"; echo;

exit

