/* SAMHAIN file system integrity testing                                   */
/* Copyright (C) 1999 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */


#ifndef SH_HASH_H
#define SH_HASH_H

#include <limits.h>

#include "samhain.h"
#include "sh_unix.h"
#include "sh_error.h"

/* List database content
 */
int sh_hash_list_db (char * db_file);

/* List database content with full detail
 */
int set_full_detail (char * c);

/* Read the database from disk.
 */
void sh_hash_init (void);

/* Check whether a file is present in the database.
 */
int sh_hash_have_it (char * newname);

/* Delete the database from memory.
 */
void sh_hash_hashdelete (void);

/* Insert a file into the database.
 */ 
void sh_hash_pushdata (file_type * buf, char * fileHash);

/* Compare a file with its status in the database.
 */ 
void sh_hash_compdata (int class,
		       file_type * theFile, 
		       char * fileHash);

/* Search for files in the database that have been deleted from disk.
 */
void sh_hash_unvisited (ShErrLevel level);

/* Set a file's status to 'visited'. This is required for
 * files that should be ignored, and may be present in the
 * database, but not on disk.
 */
int sh_hash_set_visited (char * newname);

/* As above, but only set the 'visited' flag
 */
int sh_hash_set_visited_true (char * newname);

/* cause the record to be deleted without a 'missing' message
 */
int sh_hash_set_missing (char * newname);

/* Make a complete directory tree invisible
 */
int hash_remove_tree (char * s);

/* Make every entry visible 
 */
int hash_full_tree (void); 

#endif
