#include "config_xor.h"

#include <stdio.h>


#if defined (SH_WITH_CLIENT) || defined (SH_STANDALONE) 

#include "sh_modules.h"

#include "sh_utmp.h"
#include "sh_kern.h"
#include "sh_suidchk.h"

sh_mtype modList[] = {
#ifdef SH_USE_UTMP
  {
    N_("UTMP"),
    0,
    sh_utmp_init,
    sh_utmp_timer,
    sh_utmp_check,
    sh_utmp_end,

    N_("[Utmp]"),
    sh_utmp_table,
  },
#endif
#ifdef SH_USE_KERN
  {
    N_("KERNEL"),
    0,
    sh_kern_init,
    sh_kern_timer,
    sh_kern_check,
    sh_kern_end,

    N_("[Kernel]"),
    sh_kern_table,
  },
#endif
#ifdef SH_USE_SUIDCHK
  {
    N_("SUIDCHECK"),
    0,
    sh_suidchk_init,
    sh_suidchk_timer,
    sh_suidchk_check,
    sh_suidchk_end,

    N_("[SuidCheck]"),
    sh_suidchk_table,
  },
#endif
  {
    NULL,
    0,

    NULL,
    NULL,
    NULL,
    NULL,

    NULL,
    NULL,
  },
};

#endif

