#ifndef SH_TOOLS_H
#define SH_TOOLS_H

#define SH_DO_WRITE 0
#define SH_DO_READ  1

/* protocols
 */
#define SH_PROTO_SRP (1 << 0)
#define SH_PROTO_MSG (1 << 2)
#define SH_PROTO_BIG (1 << 3)
#define SH_PROTO_END (1 << 4)
#define SH_PROTO_ENC (1 << 5)

#ifdef SH_ENCRYPT
char * errorExplain (int err_num);
#endif

char * sh_tools_safe_name(const char * str, int flag);
int is_numeric (const char * address);
int connect_port (char * address, int port, 
		  char * ecall, int * errnum, char * errmsg, int errsiz);
int connect_port_2 (char * address1, char * address2, int port, 
		    char * ecall, int * errnum, char * errmsg, int errsiz);
void delete_cache(void);


#if defined (SH_WITH_SERVER)

int get_open_max (void);

void put_header (unsigned char * head, int protocol, 
		 unsigned long * length, char * u);

int check_request_s (char * have, char * need, char * clt);
int check_request_nerr (char * have, char * need);

char * hash_me (char * key, char * buf,   int buflen);

char * get_client_conf_file (char * peer, unsigned long * length);
char * get_client_data_file (char * peer, unsigned long * length);

#endif

unsigned long read_port (int sockfd, char *buf, unsigned long nbytes, 
	       int * w_error, int timeout);


#if defined (SH_WITH_CLIENT)

unsigned long write_port (int sockfd, char *buf, unsigned long nbytes, 
			  int * w_error, int timeout);

int check_request (char * have, char * need);
int check_request_nerr (char * have, char * need);

void get_header (unsigned char * head, unsigned long * bytes, char * u);
void put_header (unsigned char * head, int protocol, 
		 unsigned long * length, char * u);


SL_TICKET open_tmp (void);
int close_tmp (SL_TICKET fd);
int rewind_tmp (SL_TICKET fd);

int hash_check(char * key, 
	       char * buf,   int buflen);

#endif


#endif
